#include <iostream>
#include <string>
#include <thread>
#include <chrono>
#include <conio.h> // for _getch() and _kbhit()
#include <windows.h>
#include <locale.h>
using namespace std;

#define UpArrow 72
#define DownArrow 80
#define RightArrow 77
#define LeftArrow 75 
#define Enter 13
#define Escape 27
#define Null 0

void halt(int ms = 800){ // Default wait time of 800 ms
    this_thread::sleep_for(chrono::milliseconds(ms));
}

void typewrite(const string& text, int delay_ms = 10)  {  // Default of delay 10 ms        
        for (char character: text) {

           
            if (_kbhit()) {
                _getch();
            }
            
            cout << character << flush; // Print the character
            this_thread::sleep_for(chrono::milliseconds(delay_ms)); // Delay
        }
    } // Typewriter effect function

    void enterinput(){
     while (_kbhit()) {
        _getch();
    }
    
    cin.clear();

    while(true) {

        int tus = _getch();
        if (tus == 13) break;
        while (_kbhit()) _getch(); // Clear any pending characters
    }

}

void clearscreen(){
    for(int i= 0; i<50; i++) {

        cout << "\n";
    }
    cout<<"------------------------------------------------------------------------------------------------------------------------\n";
} // Function for clearing the screen

void mainmenu()
{
    cout<<"Welcome to the Main Menu\n";
    cout<<"Pick one of the shown options below :\n \n Option 1 : Serial Circuit \n Option 2 : Parallel Circuit \n Option 3 : Mixed Circuit (NOT BUILT YET) \n Option 4 : Exit Program\n";
}

int resamountcheck(int value){
    if (cin.fail() || value < 1){
        typewrite("\nDetected an invalid input \nPlease enter a valid number\n \n");
        cin.clear(); // Clear the error flag
        cin.ignore(1000, '\n'); // Discard invalid input
        return -1;
    } 
    else if(value > 25){
        typewrite("\nThe maximum number of resistors is 25 \nPlease enter value less than 26\n\n");
        cin.clear(); // Clear the error flag
        cin.ignore(1000, '\n'); // Discard invalid input
        return -1;
    }
    else{
        return 1; // Valid input

}
}

int ohmvaluetcheck(int value){
    if (cin.fail() || value < 1){
        typewrite("\nDetected an invalid input\nPlease enter a valid number\n \n");
        cin.clear(); // Clear the error flag
        cin.ignore(1000, '\n'); // Discard invalid input
        return -1;
    } 
    else if(value > 10000000){
        typewrite("\nValue entered for ohm value is way too large\n Please enter a smaller number\n \n");
        cin.clear(); // Clear the error flag
        cin.ignore(1000, '\n'); // Discard invalid input
        return -1;
    }
    else{
        return 1; // Valid input

}
}

int voltvaluetcheck(int value){
    if (cin.fail() || value < 1){
        typewrite("\nDetected an invalid input\nPlease enter a valid number\n\n");
        cin.clear(); // Clear the error flag
        cin.ignore(1000, '\n'); // Discard invalid input
        return -1;
    } 
    else if(value > 10000){
        typewrite("\nValue entered for volt value is way too large\nPlease enter a smaller number\n\n");
        cin.clear(); // Clear the error flag
        cin.ignore(1000, '\n'); // Discard invalid input
        return -1;
    }
    else{
        return 1; // Valid input

}
}

void currentcircuit(double voltv, double ohmv, double ampv){
    cout<<"                                   Rtotal = "<<ohmv<<" ohms \n";
    cout<<"  ┌────────────────────>──────────────────┨█████┠─────────────────>─────────────────────┐\n";
    cout<<"  │                                                                                     │\n";
    cout<<"  │                                                                                     │\n";
    cout<<"  ^ Direction of the Current                                                            V\n";
    cout<<"  │                                                                                     │\n";
    cout<<"  │                                                                                     │\n";
    cout<<"  └────────────────────<───────────────────┨   ┠──────────────────<─────────────────────┘\n";
    cout<<"                                    Volt = "<<voltv<<" volts \n";
    cout<<"                                    I = "<<ampv<<" amperes \n \n";
}

void SerialCircuit(){
    typewrite("--- Serial Circuit --- \n");
    typewrite("\nPlease write the amount of resistors in the circuit\n\n");
    int totalres;
    while(true){
    cin>>totalres;
    if (resamountcheck(totalres) == -1) continue;
    else break;
}
typewrite("You have "); cout<<totalres; typewrite(" resistors in the circuit\n \n"); 
    int currentres = 1;
    double ohmvalue;
    double totalohm = 0; 
    double voltvalue;
    double ampervalue;
    typewrite("Please type the voltage value of the circuit\n \n");
    while(true){
    cin>>voltvalue;
    if (voltvaluetcheck(voltvalue) == -1) continue;
    else break;
    }
    while(currentres<=totalres){
        typewrite("\nPlease type the ohm value of resistor "); cout<<currentres; typewrite("\n \n");
        while(true){
        cin>>ohmvalue;
        if (ohmvaluetcheck(ohmvalue) == -1) continue;
        else break;
        }
        totalohm += ohmvalue;
        ampervalue = voltvalue/totalohm;
        clearscreen();
        if (currentres < totalres){
        typewrite("The Circuit so far looks like : \n \n");
        currentcircuit(voltvalue, totalohm, ampervalue);
        halt(250);
        }
        currentres++;
        }
    clearscreen();
    typewrite("The Final Circuit looks like : \n \n");
    currentcircuit(voltvalue, totalohm, ampervalue);
    typewrite("Thank you for using the program\n Press enter to return to the main menu\n");
    enterinput();
    clearscreen();

}

void ParallelCircuit(){
    typewrite("--- Parallel Circuit --- \n");
    typewrite("\nPlease write the amount of resistors in the circuit\n\n");
    int totalres;
    while(true){
    cin>>totalres;
    if (resamountcheck(totalres) == -1) continue;
    else break;
    }
    typewrite("You have "); cout<<totalres; typewrite(" resistors in the circuit\n \n"); 
    int currentres = 1;
    double ohmvalue;
    double totalohm = 0; 
    double voltvalue;
    double ampervalue;
    typewrite("Please type the voltage value of the circuit\n \n");
    while(true){
    cin>>voltvalue;
    if (voltvaluetcheck(voltvalue) == -1) continue;
    else break;
    }
    while(currentres<=totalres){
        typewrite("\nPlease type the ohm value of resistor "); cout<<currentres; typewrite("\n \n");
        while(true){
        cin>>ohmvalue;
        if (ohmvaluetcheck(ohmvalue) == -1) continue;
        else break;
        }
        if (currentres == 1){
            totalohm = ohmvalue;
            ampervalue = voltvalue/totalohm;
        }
        else{
        totalohm = (ohmvalue*totalohm)/(ohmvalue+totalohm);
        ampervalue = voltvalue/totalohm;
        }
        clearscreen();
        if (currentres < totalres){
        typewrite("The Circuit so far looks like : \n \n");
        currentcircuit(voltvalue, totalohm, ampervalue);
        halt(250);
        }
        currentres++;
        }
    clearscreen();
    typewrite("The Final Circuit looks like : \n \n");
    currentcircuit(voltvalue, totalohm, ampervalue);
    typewrite("Thank you for using the program\n Press enter to return to the main menu\n");
    enterinput();
    clearscreen();

}

void chosen(){
    int choice;
    while(true){
    cin>>choice;
    if (cin.fail() || choice < 1 || choice > 4){
        typewrite("Invalid input, please try again\n\n");
        cin.clear(); // Clear the error flag
        cin.ignore(1000, '\n'); // Discard invalid input
        continue;
        }
    else break;
    }
    halt(100);
    if (choice == 1){
        typewrite("Chosen option is Serial Circuit \n \n");
        halt(400);
        clearscreen();
        SerialCircuit();
    } 
     if (choice == 2) {
        typewrite("Chosen option is Parallel Circuit\n \n");
        halt();
        clearscreen();
        ParallelCircuit();
    }
    if (choice == 3){
        typewrite("Chosen option is Mixed Circuit\n this part of the program is not built yet \n returning to the main menu \n");
        halt();
        clearscreen();
    }
    if (choice == 4){
        typewrite("You have chosen to exit the program... \n \n...Exiting programn\n");
        halt(200);
        exit(0);
    }
} 


int main(){

    SetConsoleOutputCP(65001);
    SetConsoleCP(65001);
    typewrite("Welcome to the official release of Circuit Calculator v0.5\n");
    typewrite("This program is still in development and may have inaccuracies & bugs\n");
    typewrite("Press the \"Enter\" key to continue \n");
    enterinput();
    typewrite("Continuing to the Main Menu \n");
    halt();
    clearscreen();

    while(true){
    mainmenu();
    chosen();
    }

    return 0;
}